---
title: Download and install WARP · Cloudflare Learning Paths
description: Most admins test by manually downloading the WARP client and
  enrolling in your organization's Cloudflare Zero Trust instance.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/connect-devices-networks/install-agent/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/connect-devices-networks/install-agent/index.md
---

Most admins test by manually downloading the WARP client and enrolling in your organization's Cloudflare Zero Trust instance.

## Install WARP

1. First, uninstall any existing third-party VPN software if possible. Sometimes products placed in a disconnected or disabled state will still interfere with the WARP client.

2. If you are running third-party firewall or TLS decryption software, verify that it does not inspect or block traffic to the following destinations:

   * IPv4 API endpoints: `162.159.137.105` and `162.159.138.105`
   * IPv6 API endpoints: `2606:4700:7::a29f:8969` and `2606:4700:7::a29f:8a69`
   * SNIs: `zero-trust-client.cloudflareclient.com` and `notifications.cloudflareclient.com`

   For more information, refer to [WARP with firewall](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).

3. Manually install WARP on the device.

   Window, macOS, and Linux

   To enroll your device using the WARP GUI:

   1. [Download](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/) and install the WARP client.

   2. Launch the WARP client.

   3. Select the Cloudflare logo in the menu bar.

   4. Select the gear icon.

   5. Go to **Preferences** > **Account**.

   6. Select **Login with Cloudflare Zero Trust**.

   7. Enter your team name.

   8. Complete the authentication steps required by your organization.

      Once authenticated, you will see a Success page and a dialog prompting you to open WARP.

   9. Select **Open Cloudflare WARP.app** to complete the registration.

   iOS, Android, and ChromeOS

   1. [Download](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/) and install the Cloudflare One Agent app.
   2. Launch the Cloudflare One Agent app.
   3. Select **Next**.
   4. Review the privacy policy and select **Accept**.
   5. Enter your team name.
   6. Complete the authentication steps required by your organization.
   7. After authenticating, select **Install VPN Profile**.
   8. In the **Connection request** popup window, select **OK**.
   9. If you did not enable [auto-connect](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#auto-connect), manually turn on the switch to **Connected**.

The WARP client should show as **Connected**. The device is now connected to your organization and secured with Cloudflare Zero Trust.
